-- Grass

local bladeMin, bladeMax = 10, 20
local bladeJitterX, bladeJitterY = 15, 8
local bladeSpacingX, bladeSpacingY = 30, 6
local windPower = 5.0
local col1 = color(12, 255, 0)
local col2 = color(0)

local wind = vec2(-1, 0)
local blades = {}
local p

function addAnimal(blade)
    if math.random() > 0.5 then
        blade.animal = asset.cow
    else
        blade.animal = asset.pig
    end
end

function setup()
    -- Initialise wind
    wind = wind:rotate(math.rad(math.random(-45, 45)))
    
    -- Initialise perlin noise
    p = perlin(math.random(math.mininteger, math.maxinteger))
    
    strokeWidth(4)
    spriteMode(CENTER)
    
    -- Generate grass blades
    for x = 0, WIDTH, bladeSpacingX do
        for y = HEIGHT, 0, -bladeSpacingY do
            local blade = {
                x = x + math.random(-bladeJitterX, bladeJitterX),
                y = y + math.random(-bladeJitterY, bladeJitterY),
                len = math.random(bladeMin, bladeMax),
                col = col1:mix(col2, (p:noise(x * 0.007, y * 0.007) + 1.0) / 2.0)
            }
            if ((#blades)%80 == 0) and p:noise(blade.x * 0.01, blade.y * 0.01) > 0.4 then
                addAnimal(blade)
            end
            table.insert(blades, blade)
        end
    end
    
    print("Generated " .. #blades .. " blades of grass.")
    
    viewer.mode = FULLSCREEN_NO_BUTTONS
end
    
function draw()
    background(22, 31, 21)
    
    local windOffset = wind * ElapsedTime * 120
    
    for i,b in ipairs(blades) do
        local nx = (b.x+windOffset.x) * 0.007
        local ny = (b.y+windOffset.y) * 0.007
        local n = (p:noise(nx, ny) + 1.0) / 3.0
        local offset = (n * b.len * 0.4 * windPower)
        stroke(b.col)
        line(b.x, b.y, b.x + offset, b.y + b.len)
        if b.animal then sprite(b.animal, b.x, b.y + offset, 40, 30) end
    end
end

